﻿/*
** Copyright (C) 2011 - 2015 PROMESS
** Gesellschaft für Montage und Prüfsysteme mbH
** ALL RIGHTS RESERVED
** Developers:
** Andreas Groch
*/

using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace AstasDllCSharpTest
{
    using Astas;

    public partial class FrmMain
    {
        private static bool AstasInit()
        {
            bool rc;

            ErrorCode astasErrCode = AstasMethods.Init();

            if (astasErrCode == ErrorCode.NoErr) {
                rc = true;
            }
            else {
                rc = false;
                ShowAstasError("Init", astasErrCode);
            }

            return rc;
        }

        private static bool AstasReInit()
        {
            bool rc = false; 

            try {
                ErrorCode astasErrCode = AstasMethods.ReInit();

                if (astasErrCode == ErrorCode.NoErr) {
                    rc = true;
                }
                else {
                    rc = false;
                    ShowAstasError("ReInit", astasErrCode);
                }
            }
            catch (Exception ex) {
                MessageBox.Show(ex.Message, Application.ProductName);
            }

            return rc;
        }

        private static DllVersion AstasDllVersion()
        {
          DllVersion dll_vers = AstasMethods.DllVersion();

          return dll_vers;
        }

        /// <summary>
        /// Returns true if the 
        /// </summary>
        /// <returns></returns>
        private bool AstasSearch()
        {
            bool rc = false;

            try {
                DeviceInfo deviceInfo = new DeviceInfo();

                int devCount = AstasMethods.Search(out deviceInfo);
                
                this.txtDevCount.Text = devCount.ToString(CultureInfo.CurrentCulture);
                if (devCount > 0) {
                    rc = true;
                }
                else {
                    this.toolStripStatusLabelAstas.Text = "No Astas device found!";
                }
            }
            catch (Exception ex) {
                if (!(ex is SystemException)) {
                    throw;
                }
                MessageBox.Show(ex.Message);
            }

            return rc;
        }

        private bool AstasOpen()
        {
            bool rc = false;

            const int DeviceIndex = 0;
            ErrorCode astasErrCode = AstasMethods.Open(DeviceIndex);
            if (astasErrCode == ErrorCode.NoErr) {
                rc = true;
                this.toolStripStatusLabelAstas.Text = "Astas is open!";
            }
            else {
                rc = false;
                ShowAstasError("Open", astasErrCode);
                this.toolStripStatusLabelAstas.Text = "Astas is not open!";
            }

            return rc;
        }

        private void AstasClose()
        {
            const int DeviceIndex = 0;
            ErrorCode astasErrCode = AstasMethods.Close(DeviceIndex);
            if (astasErrCode != ErrorCode.NoErr) {
                ShowAstasError("Close", astasErrCode);
            }
            this.toolStripStatusLabelAstas.Text = "Astas is closed!";
        }

        private bool AstasReadData()
        {
            bool rc;

            const int DeviceIndex = 0;
            DeviceData astasDeviceData = new DeviceData();
            ErrorCode errCode = AstasMethods.ReadData(DeviceIndex, out astasDeviceData);
            if (errCode == ErrorCode.NoErr) {
                this.textBox1.Text = astasDeviceData.me.ToString();
                this.textBox2.Text = astasDeviceData.brutto.ToString(CultureInfo.CurrentCulture);
                this.textBox3.Text = astasDeviceData.netto.ToString(CultureInfo.CurrentCulture);
                this.textBox4.Text = astasDeviceData.tara.ToString(CultureInfo.CurrentCulture);
                this.textBox5.Text = astasDeviceData.min.ToString(CultureInfo.CurrentCulture);
                this.textBox6.Text = astasDeviceData.max.ToString(CultureInfo.CurrentCulture);
                this.textBox7.Text = astasDeviceData.dec.ToString(CultureInfo.CurrentCulture);
                this.textBox8.Text = astasDeviceData.status.ToString();

                rc = true;
           }
           else {
                this.textBox1.Text = string.Empty;
                this.textBox2.Text = string.Empty;
                this.textBox3.Text = string.Empty;
                this.textBox4.Text = string.Empty;
                this.textBox5.Text = string.Empty;
                this.textBox6.Text = string.Empty;
                this.textBox7.Text = string.Empty;
                this.textBox8.Text = string.Empty;

                rc = false;
            }
            //astasDeviceData = null;

            return rc;
        }

        private static bool AstasNull()
        {
            bool rc;

            const int DeviceIndex = 0;
            ErrorCode astasErrCode = AstasMethods.Null(DeviceIndex);
            if (astasErrCode == ErrorCode.NoErr) {
                rc = true;
            }
            else {
                ShowAstasError("Null", astasErrCode);
                rc = false;
            }
            
            return rc;
        }

        private static bool AstasGrossNetto()
        {
            bool rc;

            const int DeviceIndex = 0;
            ErrorCode astasErrCode = AstasMethods.GrossNetto(DeviceIndex);
            if (astasErrCode == ErrorCode.NoErr) {
                rc = true;
            }
            else {
                ShowAstasError("GrossNetto", astasErrCode);
                rc = false;
            }

            return rc;
        }

        private static bool AstasChangeUnit()
        {
            bool rc;

            const int DeviceIndex = 0;
            ErrorCode astasErrCode = AstasMethods.ChangeUnit(DeviceIndex);
            if (astasErrCode == ErrorCode.NoErr) {
                rc = true;
            }
            else {
                ShowAstasError("ChangeUnit", astasErrCode);
                rc = false;
            }

            return rc;
        }

        private static bool AstasChangeRange()
        {
            bool rc;

            const int DeviceIndex = 0;
            ErrorCode astasErrCode = AstasMethods.ChangeRange(DeviceIndex);
            if (astasErrCode == ErrorCode.NoErr) {
                rc = true;
            }
            else {
                ShowAstasError("ChangeRange", astasErrCode);
                rc = false;
            }

            return rc;
        }

        private bool AstasReadNominalData()
        {
          bool rc;

          this.label9.Text = ".";
          this.checkBox1.Checked = false;

          const int DeviceIndex = 0;
          NominalData astasNominalData = new NominalData();
          ErrorCode errCode = AstasMethods.ReadNominalData(DeviceIndex, out astasNominalData);
          if (errCode == ErrorCode.NoErr)
          {
            this.label9.Text = astasNominalData.nominal_value.ToString();
            if(astasNominalData.teds == 1)
              this.checkBox1.Checked = true;
            else if (astasNominalData.teds == 0)
              this.checkBox1.Checked = false;
            this.label10.Text = "S/N " + astasNominalData.teds_sn.ToString();

            rc = true;
          }
          else
          {
            this.label9.Text = ".";
            this.checkBox1.Checked = false;

            rc = false;
          }
          //astasNominalData = null;

          return rc;
        }

        private static void ShowAstasError(string functionName, ErrorCode astasErrCode)
        {
            MessageBox.Show(functionName + ": " + astasErrCode, "ASTAS Error");
        }
    }
}
