﻿/*
** Copyright (C) 2011 - 2015 PROMESS
** Gesellschaft für Montage und Prüfsysteme mbH
** ALL RIGHTS RESERVED
** Developers:
** Andreas Groch
*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace AstasDllCSharpTest
{
    using Astas;

    public partial class FrmMain : Form
    {
        #region Private Fields

        private bool _astasIsOpen = false;
        
        #endregion Private Fields

        public FrmMain()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            try {
                this._astasIsOpen = false;
                this.timer1.Enabled = false;

                if (AstasInit())
                {
                    this.timer1.Enabled = true;

                    DllVersion dll_vers = AstasDllVersion();
                    this.Text = "ASTAS-DLL V" + dll_vers.major.ToString() + "." + dll_vers.minor.ToString() + "." + dll_vers.revision.ToString() + "." + dll_vers.build.ToString();

                    if((dll_vers.major >= 0) && (dll_vers.minor >= 14))
                      this.panel1.Visible = true;
                    else
                      this.panel1.Visible = false;
                }
            }
            catch (Exception ex) {
                if (!(ex is SystemException)) {
                    throw;
                }
                MessageBox.Show(ex.Message, Application.ProductName);
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            timer1.Enabled = false;
            
            if (this._astasIsOpen) {
//                this.AstasReadData();

                if (!this.AstasReadData()) {
                    this.AstasClose();
                    this._astasIsOpen = false;
                }

            }
            else {
                if (this.AstasSearch()) {
                    this._astasIsOpen = AstasOpen();
                }
                else {
                    this._astasIsOpen = false;
                }
            }

            timer1.Enabled = true;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            timer1.Enabled = false;

            if (this._astasIsOpen) {
                this.AstasClose();
            }
        }

        private void btnReInit_Click(object sender, EventArgs e)
        {
            this.timer1.Enabled = false;

            if (AstasReInit()) {
                this.timer1.Enabled = true;
            }
        }

        private void btnNull_Click(object sender, EventArgs e)
        {
            if (this._astasIsOpen) {
                AstasNull();
            }
        }

        private void btnGrossNetto_Click(object sender, EventArgs e)
        {
            if (this._astasIsOpen) {
                AstasGrossNetto();
            }
        }

        private void btnChangeUnit_Click(object sender, EventArgs e)
        {
            if (this._astasIsOpen) {
                AstasChangeUnit();
            }
        }

        private void btnChangeRange_Click(object sender, EventArgs e)
        {
            if (this._astasIsOpen) {
                AstasChangeRange();
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
          this.timer1.Enabled = false;          
          this.button2.Enabled = true;

          if (this._astasIsOpen)
          {
            AstasReadNominalData();
          }
        }

        private void button2_Click(object sender, EventArgs e)
        {
          this.button2.Enabled = false;
          this.timer1.Enabled = true;
        }
    }
}
