//-----------------------------------------------------------------------------
//
// astas_dll.h - Header-File ASTAS-DLL
//
//-----------------------------------------------------------------------------
#pragma once

#ifdef DLL_EXPORT
 #define DLL_API __declspec(dllexport)
#else
 #define DLL_API __declspec(dllimport)
#endif

#ifdef _MSC_VER
 #ifdef PRAGMA_PACK_1
  #pragma pack(1)
 #endif
#endif

// --------------------------------------
// defines...
// --------------------------------------

// -> Status-Byte
#define STATUS_NONE             0x00        // 0b00000000   // leeres Status-Byte -> NULL-Status
// def. der einzelnen Status-Bits
// -> AE703 / BD341/2 / BA661/2 / FFB201 / FFB204
// RESERVE                      0x01        // 0b00000001   // Reserve                            
#define STATUS_NULL             0x02        // 0b00000010   // Status -> Null-Anzeige (Netto-Wert)
#define STATUS_TARA             0x04        // 0b00000100   // Status -> Tara/Null
#define STATUS_OVER             0x08        // 0b00001000   // Status -> Ueberlast
#define STATUS_UNDER            0x10        // 0b00010000   // Status -> Unterlast
#define STATUS_CHG_UNIT         0x20        // 0b00100000   // Status -> Aend. Masseinheit (nicht FFB20x!)
#define STATUS_CHG_RANGE        0x40        // 0b01000000   // Status -> Aend. Messbereich (nicht FFB20x!)
#define STATUS_ERR              0x80        // 0b10000000   // Status -> ADC-Error (nicht FFB20x!)
// -> Sonderwerte FFB201 / FFB204
#define STATUS_MAX              0x20        // 0b00100000   // Status -> Max.-Wert
#define STATUS_RF_IO            0x40        // 0b01000000   // Status -> RF i.O.
// RESERVRE                     0x80        // 0b10000000   // Reserve

// -> USB-VID/PID
#define MY_DEVICE_ID_AE703      "vid_04d8&pid_ff50"
#define MY_DEVICE_ID_BD342      "vid_04d8&pid_ff63"
#define MY_DEVICE_ID_BA660      "vid_04d8&pid_fc1c"
#define MY_DEVICE_ID_FFB201     "vid_04d8&pid_ff54"
#define MY_DEVICE_ID_FFB204     "vid_04d8&pid_ff55"


// -> HW-Info
#define HW_DEF_AE_703           5100        // AE703
#define HW_DEF_AE_703_PM        5110        // AE703-PM
#define HW_DEF_BD_342           5140        // BD341/2
#define HW_DEF_BA_661           5310        // BA661
#define HW_DEF_BA_662           5330        // BA662
#define HW_DEF_FFB_201          5200        // FFB201
#define HW_DEF_FFB_204          5240        // FFB204

// -> defines fuer Masseinheiten
#define UNIT_USER               0
#define UNIT_N                  1
#define UNIT_kN                 2
#define UNIT_g                  3
#define UNIT_kg                 4
#define UNIT_t                  5
#define UNIT_lbf                6
#define UNIT_oz                 7
#define UNIT_mV_V               8
#define UNIT_M300               9
#define UNIT_M600               10
#define UNIT_to                 11
// --- Drehmomenten-Einheiten (es fallen dafuer 9=M300 und 10=M600 weg) ---
#define UNIT_Nm                 9
#define UNIT_Ncm                10
#define UNIT_ozIn               12
#define UNIT_Inlb               13
#define UNIT_ftlb               14
#define UNIT_klbf               15

#define MODE_SETMIN	            1
#define MODE_SETMAX	            2

// --------------------------------------
// ERROR-defines
// --------------------------------------
#define NO_ERR                    0

#define ERR                       1

#define ERR_DEVICE_NOT_OPEN       10
#define ERR_FUNC_NOT_IMPL         20
#define ERR_DEVICE_READ           30
#define ERR_FFB_RF                40
#define ERR_ONE_DEVICE_OPEN       50
#define ERR_DEVICE_READ_FALSE     60

#define ERR_DEVICE_CALIB_MVV      100
#define ERR_DEVICE_CALIB_READ_VAL 101

#define ERR_DLL_MEM_INIT          251     // Neu ab V0.8.6 -> Fkt. Init()/ReInit(), wenn Fehler bei memset auftritt
#define ERR_DLL_CURR_INIT         252     // Neu ab V0.8.6 -> Fkt. Init(), wenn DLL schon init. war
#define ERR_DEVICE_FALSE_IDX      253
#define ERR_DEVICE_NOT_EXIST      254
#define ERR_DLL_NOT_INIT          255

// --------------------------------------
// Struktur fuer Gereate-Infos (USB-HID)
// --------------------------------------
#ifdef PRAGMA_PACK_1
 #pragma pack(1)
#endif
typedef struct
{
  DWORD usb_hid_idx;        // USB-HID-Geraete-Index -> nur fuer interne Verwendung!
  int open;                 // Zustand -> Open=1 / Close=0 -> nur fuer interne Verwendung!
  char vid_pid[256];        // VID/PID-String
  char dev_info[256];       // GeraeteInfo-String
  char sn_info[256];        // S/N-String
  int hw_info;              // HW-Info (5xxx)
  int hw_var;               // HW-Variante
  int fw_vers;              // FW-Version
//Erweiterung zu bisheriger Version - ab V0.13.x
  int chn;                  // Kanal
} t_DeviceInfo;

// --------------------------------------
// Struktur fuer Messwerte eines Geraetes - AE703 / BD341/2 / BA661/2 / FFB201/4
// --------------------------------------
#ifdef PRAGMA_PACK_1
 #pragma pack(1)
#endif
typedef struct
{
  float brutto;               // Brutto / Messwert
  float netto;                // Netto
  float tara;                 // Tara
  float min;                  // Min
  float max;                  // Max
  int me;                     // Masseinheit (0...x) - siehe oben
  int dec;                    // Anzahl Nachkommastellen
  int status;                 // Status-Byte
} t_DeviceData;

// --------------------------------------
// Struktur fuer TEDS-Nomalwerte des Messbereichs/TEDS - AE703 / BD341/2
// --------------------------------------
#ifdef PRAGMA_PACK_1
 #pragma pack(1)
#endif
typedef struct
{
  float nominal_value;        // Nennkennwert
  unsigned int teds;          // TEDS (1=Nennkennwert aus TEDS / 0=Nennkennwert aus AE703-MB) 
  unsigned int teds_sn;       // TEDS-S/N, wenn TEDS erkannt wurde
} t_NominalData;

//---

// --------------------------------------
// Funktions-Prototypen der DLL
// --------------------------------------
extern "C" DLL_API int AstasDllInit(void);
extern "C" DLL_API int AstasDllReInit(void);
extern "C" DLL_API int AstasDllSearch(t_DeviceInfo *p_dev_info);
extern "C" DLL_API int AstasDllOpen(int list_idx);
extern "C" DLL_API int AstasDllClose(int list_idx);
extern "C" DLL_API int AstasDllReadData(int list_idx, t_DeviceData *dev_dat);
extern "C" DLL_API int AstasDllNull(int list_idx);
extern "C" DLL_API int AstasDllTara(int list_idx);
extern "C" DLL_API int AstasDllGrossNet(int list_idx);
extern "C" DLL_API int AstasDllMax(int list_idx);
extern "C" DLL_API int AstasDllChangeUnit(int list_idx);
extern "C" DLL_API int AstasDllChangeRange(int list_idx);
extern "C" DLL_API int AstasDllAckChangeStatusBits(int list_idx);
extern "C" DLL_API int AstasDllCalibNull(int list_idx);
extern "C" DLL_API int AstasDllCalibEnd(int list_idx, float cal_val);
extern "C" DLL_API int AstasDllCalibSave(int list_idx);
extern "C" DLL_API int AstasDllCalibDelete(int list_idx);
extern "C" DLL_API int AstasDllSetMinMax(int list_idx, int mode);
extern "C" DLL_API int AstasDllReadNominalData(int list_idx, t_NominalData *p_nominal_data);
extern "C" DLL_API int AstasDllReset(int list_idx);
extern "C" DLL_API int AstasDllDLLVersion(void);
